﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;

//access resource.resx
using System.Resources;

//our data access class library
using DataAccess;

/// <summary>
/// Summary description for CLabData
/// </summary>
public class CLabDataXfer : CData
{
    public CLabDataXfer(CData data)
        : base(data)
    {
        //constructors are not inherited in c#!
    }

    /// <summary>
    ///US:852 saves a lab test to the database
    /// </summary>
    /// <param name="lXferSystemID"></param>
    /// <param name="nLabTestID"></param>
    /// <param name="strName"></param>
    /// <param name="strHIREF"></param>
    /// <param name="strLOREF"></param>
    /// <param name="strREFRANGE"></param>
    /// <param name="strUnits"></param>
    /// <param name="strDescription"></param>
    /// <returns></returns>
    public CStatus SaveLabTest( long lXferSystemID,
                                string strLabTestID,
                                string strName,
                                string strHIREF,
                                string strLOREF,
                                string strREFRANGE,
                                string strUnits,
                                string strDescription,
                                string strLOINC)
    {
        CStatus status = new CStatus();

        //load the paramaters list
        CDataParameterList pList = new CDataParameterList(base.SessionID,
                                                  base.ClientIP,
                                                  base.UserID);

        pList.AddInputParameter("pi_nXferSystemID", lXferSystemID);
        pList.AddInputParameter("pi_vLabTestID", strLabTestID);
        pList.AddInputParameter("pi_vName", strName);
        pList.AddInputParameter("pi_vHIREF", strHIREF);
        pList.AddInputParameter("pi_vLOREF", strLOREF);
        pList.AddInputParameter("pi_vREFRANGE", strREFRANGE);
        pList.AddInputParameter("pi_vUnits", strUnits);
        pList.AddInputParameter("pi_vDescription", strDescription);
        pList.AddInputParameter("pi_vLOINC", strLOINC);
       
        return DBConn.ExecuteOracleSP("PCK_LAB.SaveLabTest",
                                       pList);
    }

    /// <summary>
    ///US:852 gets lab tests matching search criteria
    /// </summary>
    /// <param name="strSearch"></param>
    /// <param name="ds"></param>
    /// <returns></returns>
    public CStatus GetLabTestDS( string strSearch, 
                                 out DataSet ds)
    {
        //initialize parameters
        ds = null;
        CStatus status = new CStatus();

        //load the paramaters list
        CDataParameterList pList = new CDataParameterList(base.SessionID,
                                                          base.ClientIP,
                                                          base.UserID);
        
        pList.AddInputParameter("pi_vSearch", strSearch);
        
        //get the dataset
        CDataSet cds = new CDataSet();
        status = cds.GetOracleDataSet(base.DBConn,
                                       "PCK_LAB.GetLabTestRS",
                                       pList,
                                       out ds);

       
        return status;
    }

}